/*
 * CTreeWidget.cpp
 *
 *  Created on: 07.05.2009
 *      Author: stefan.detter
 */

#include "TreeView.h"

#include <QHeaderView>
#include <QMouseEvent>

TreeView::TreeView( QWidget * parent )
	: QTreeView(parent)
{
	QTreeView::header()->setStretchLastSection(true);
}

TreeView::~TreeView()
{
}


void TreeView::setColumnPercentWidth ( int column, uchar percent )
{
	m_percentWidth.resize(this->model()->columnCount());

	m_percentWidth[column] = percent;
}

void TreeView::resizeEvent ( QResizeEvent * event )
{
	int width = this->size().width();
	double percWidth = ((double)width)/101.0;
	for(int i = 0; i < m_percentWidth.size(); i++)
	{
		if(m_percentWidth.at(i) != 0){
			int colWidth = m_percentWidth.at(i) * percWidth;
			if(colWidth == 0) colWidth = 1;
			this->setColumnWidth(i, colWidth);
		}
	}

	QTreeView::resizeEvent(event);
}

void TreeView::mousePressEvent ( QMouseEvent * event )
{
	if(event->button() == Qt::LeftButton){
		QModelIndex i = this->indexAt(event->pos());
		if(!i.isValid()){
			emit clickedIntoFreeSpace();
			this->clearSelection();
		}
	}

	QTreeView::mousePressEvent(event);
}
